/* AMX Mod script.
*
* (c) Copyright 2005, Leichenklaus 
* This file is provided as is (no warranties). 
*
*
* Stats plugin for headshots
* Headshots will be saved using steamid (or by name @ LAN - set hs_id "1" at server.cfg)
* Leader is called HeadShot Master
* say "/master", ".master", "/hs" oder ".hs" - shows the current HeadShot Master 
* say "/myhs", ".myhs" - shows your current rank on the HeadShot Master list and the headshots you made
* Headshot made by HeadShot Master will play the HeadShot-Master-Sound
* Other players will get the well known "headshot"
* The list runs from monday 12.00 AM to sunday 11.59 PM (default) but at least until the current map ends
* By setting the variable hs_reset u can change reset point to daily or monthly
* Then the list will be deleted and a new round will be started
* Of course TKs do not count 
*
*/

// Uncomment for SQL version
//#define USING_SQL

#include <amxmodx>
#include <amxmisc>
#include <csx>
#if defined USING_SQL
#include <dbi>
#endif

#define MESSAGES   7

new messages[MESSAGES][] = {                     /* random hud messages which announce default headshots (see hs_master.txt language file) */
  "HS_MSG_1",
  "HS_MSG_2",
  "HS_MSG_3",
  "HS_MSG_4",
  "HS_MSG_5",
  "HS_MSG_6",
  "HS_MSG_7"
}

#define MAX_USERS 2000                                 /* Maximum count which will be saved in the list */

/* When should the list be reset:
* 0 - daily at midnight
* 1 - weekly at sunday midnight (default)
* 2 - monthly at the 1. of month */
new hs_reset = 1
new syncHud
new nick[MAX_USERS][33]
new steamid[MAX_USERS][33]
new kills[MAX_USERS][6]
new maxhs = 0
new minplayers = 3                                          /* If more than minplayers are on the server, the headshot counts for HS_Master */
#if defined USING_SQL
new host[64],user[32],pass[32],db[32],table[32],tableOLD[32],error[128]
#else
new save_data_file[72]
new file_master[72]
#endif

public plugin_init() {

   syncHud = CreateHudSyncObj()
#if defined USING_SQL
   register_plugin("HeadShot Master SQL","1.0","Leichenklaus")
#else
   register_plugin("HeadShot Master","1.0","Leichenklaus")
#endif   
   register_dictionary("hs_master.txt")     /*    language file   */
   register_cvar("master_delete","1")
   register_cvar("HS_Master", "")
   register_cvar("hs_id","0")                     /*    "0" for Internet (default) , "1" for LAN (set in server.cfg for LAN) */
   register_clcmd("say /master","Master_zeigen",0,"- shows the current HeadShot Master")
   register_clcmd("say .master","Master_zeigen",0,"- shows the current HeadShot Master")
   register_clcmd("say /hs","Master_zeigen",0,"- shows the current HeadShot Master")
   register_clcmd("say .hs","Master_zeigen",0,"- shows the current HeadShot Master")
   register_clcmd("say /myhs","myHS_zeigen",0,"- shows your rank on the HeadShot Master ranking")
   register_clcmd("say .myhs","myHS_zeigen",0,"- shows your rank on the HeadShot Master ranking")
#if defined USING_SQL
   register_cvar("amx_sql_host","127.0.0.1")      /* fill in your mysql access data */
   register_cvar("amx_sql_user","root")
   register_cvar("amx_sql_pass","")
   register_cvar("amx_sql_db","amx")
   tableOLD = "hsmaster" /* table where the last week's ranking will be saved */
   table = "hsliste"   /* table where the ranking will be saved */
   LoadMaster()
#else
   get_datadir(save_data_file, 71);
   format(save_data_file, 71, "%s/hsmaster.txt", save_data_file);   /* file where the ranking will be saved */
   get_datadir(file_master, 71);
   format(file_master, 71, "%s/master.txt", file_master);  /* file where the index number of the leader will be saved */
   LoadMaster(save_data_file)
#endif
}

public Master_zeigen (){
  new  message[128]
  new who_master = get_cvar_num("HS_Master")
  new who_masterString[5]
  get_cvar_string("HS_Master",who_masterString,4)
  set_hudmessage(255, 200, 0, -1.0, 0.30, 0, 6.0, 6.0, 0.5, 0.15, -1)
  if (equal(who_masterString,"")){
    format( message, 127, "%L",LANG_PLAYER,"NO_HS_MSG")
    ShowSyncHudMsg(0, syncHud, message )
  }
  else{
  trim(nick[who_master])
  format( message, 127, "%L",LANG_PLAYER,"HS_MSG",nick[who_master], kills[who_master],(equal(kills[who_master],"1"))?"":"S")
  ShowSyncHudMsg(0, syncHud, message )
  }
}

public myHS_zeigen (id){

  new ask_str[33]
  new j = 0, array_pos = -1, found_flag = 0, killnum = 0, rank = maxhs + 1
  new master_id_str[2]
  get_cvar_string("hs_id",master_id_str,1)
  if (equal(master_id_str,"0")){
    get_user_authid(id,ask_str,32)
    while (j <= maxhs){
       if (equal(ask_str, steamid[j])){
         array_pos = j
         found_flag = 1
         killnum = str_to_num(kills[j])         
       }
       j++
    }
  }
  else {
    get_user_name(id,ask_str,32)
    trim(ask_str)
    while (j <= maxhs){
       trim (nick[j])
       if (equal(ask_str, nick[j])){
         array_pos = j
         found_flag = 1
         killnum = str_to_num(kills[j])         
       }
       j++
    }
  }
  if (found_flag == 1){
    new i = 0    
    while (i <= maxhs){
         if (killnum >= str_to_num(kills[i])){
           if (i != array_pos){
             rank--
           }	 
         }
         i++
       }   
  }  
  if (found_flag == 1){
    client_print(id,print_chat,"%L",LANG_PLAYER,"HS_RANK_MSG",rank,killnum,(equal(kills[array_pos],"1"))?"":"S")
  }
  else{
    client_print(id,print_chat,"%L",LANG_PLAYER,"HS_NO_RANK_MSG")

  }
}

bool:check_reset(){
	new reset_str[8]
	if (hs_reset == 0){
		get_time("%H",reset_str,7)
		if (equal(reset_str,"00")){ 
			return true
		}
	}
	if (hs_reset == 1){
		get_time("%a",reset_str,7)
		if (equal(reset_str,"Mon")){
			return true
		}
	}
	if (hs_reset == 2){
		get_time("%d",reset_str,7)
		if (equal(reset_str,"01")){
			return true
		}
	}
	return false
}
  
#if defined USING_SQL
public LoadMaster (){
get_cvar_string("amx_sql_host",host,63)
get_cvar_string("amx_sql_user",user,31)
get_cvar_string("amx_sql_pass",pass,31)
get_cvar_string("amx_sql_db",db,31)
new Sql:sql = dbi_connect(host,user,pass,db,error,127)
if (sql <= SQL_FAILED){
	server_print(error)
	return PLUGIN_HANDLED
}
dbi_query(sql,"CREATE TABLE IF NOT EXISTS `%s`(  nick varchar(33) NOT NULL default '',  steamid varchar(33) NOT NULL default '',  kills int(5) NOT NULL default '0')",table)
dbi_query(sql,"CREATE TABLE IF NOT EXISTS `%s`(  nick varchar(33) NOT NULL default '',  steamid varchar(33) NOT NULL default '',  kills int(5) NOT NULL default '0')", tableOLD)
new pos = 0
if (get_cvar_num("master_delete")){
      if (!check_reset()){                                                       /* Day the list will be reset (default monday) */
        set_cvar_num("master_delete",0)
      }
    }
else{
if (check_reset()){
      set_cvar_num("master_delete", 1)
      set_cvar_string("HS_Master", "")
      
      dbi_query(sql, "DROP TABLE `%s`", tableOLD)                                  /* delete old table */
      dbi_query(sql, "RENAME TABLE `%s` TO `%s`", table,tableOLD)                  /* rename table to old table */
      dbi_query(sql, "CREATE TABLE `%s`(  nick varchar(33) NOT NULL default '',  steamid varchar(33) NOT NULL default '',  kills int(5) NOT NULL default '0')",table) /* create a new table */
    }
} 
new Result:Res = dbi_query(sql, "SELECT `nick` , `steamid` , `kills` FROM `%s` ORDER BY kills DESC", table)
if (Res == RESULT_FAILED) {
    dbi_error(sql,error,127)
    server_print(error)
    dbi_free_result(Res)
    dbi_close(sql)
    return PLUGIN_HANDLED
}
else if (Res == RESULT_NONE) {
    dbi_free_result(Res)
    dbi_close(sql)
    return PLUGIN_HANDLED
}    
pos = 0
while( dbi_nextrow(Res) > 0 ) {
    dbi_result(Res, "nick", nick[pos], 32)
    dbi_result(Res, "steamid", steamid[pos], 32)
    dbi_result(Res, "kills", kills[pos], 5)
    pos++
}
maxhs = pos 
set_cvar_string("HS_Master", "0")
dbi_free_result(Res)
dbi_close(sql)
return PLUGIN_HANDLED
}

public SaveMaster(){
new Sql:sql = dbi_connect(host,user,pass,db,error,127)
if (sql <= SQL_FAILED){
  server_print(error)
  return PLUGIN_HANDLED
}
dbi_query(sql,"CREATE TABLE IF NOT EXISTS `%s`(  nick varchar(33) NOT NULL default '',  steamid varchar(33) NOT NULL default '',  kills int(5) NOT NULL default '0')",table)
dbi_query(sql,"CREATE TABLE IF NOT EXISTS `%s`(  nick varchar(33) NOT NULL default '',  steamid varchar(33) NOT NULL default '',  kills int(5) NOT NULL default '0')", tableOLD)
dbi_query(sql, "TRUNCATE TABLE `%s`", table)          /* empty the table */
new b = 0
while (b < maxhs){
  	dbi_query (sql, "INSERT INTO `%s` ( `nick` , `steamid` , `kills` ) VALUES ('%s', '%s', '%s')", table, nick[b], steamid[b], kills[b])
  	b++
}
dbi_close(sql)
return PLUGIN_HANDLED 
}

#else

public LoadMaster (file_name[]){
  new line_text[74]
  new a, pos = 0
  if (get_cvar_num("master_delete")){
    if (!check_reset()){                                                       /* Day the list will be reset (default monday) */
      set_cvar_num("master_delete",0)
    }
  }
  else{
    if (check_reset()){
      set_cvar_num("master_delete", 1)
      set_cvar_string("HS_Master", "")
      if (file_exists(file_name)){
        new file_old[72]
        if (file_exists(file_master)){ 
          delete_file (file_master)
        }
        get_datadir(file_old, 71);
        format(file_old, 71, "%s/hsmasterOLD.txt", file_old);                 /* File where the old list will be saved before starting a new one */
        if (file_exists(file_old)){ 
          delete_file (file_old)
        }
        while (read_file(file_name, pos, line_text, 73, a)){
          write_file (file_old, line_text, pos)
          pos++ 
        }
        delete_file (file_name)
      }
    }
  }
  
  if (file_exists(file_master)){
    pos = 0
    read_file(file_master, pos, line_text, 73, a) 
    set_cvar_string("HS_Master", line_text)
  }
  if (file_exists(file_name)){
    pos = 0
    while (read_file(file_name, pos, line_text, 73, a)){
      parse(line_text,nick[pos],32, steamid[pos], 32, kills[pos], 5)
      pos++ 
    }
    maxhs = pos 
  }
}

public SaveMaster (){
  
  new text[74], b = 0
  new who_masterString[5]
  get_cvar_string("HS_Master",who_masterString,4)
  if (file_exists(file_master)){ 
          delete_file (file_master)
        }
  write_file (file_master, who_masterString, b)
  if (file_exists(save_data_file)){ 
          delete_file (save_data_file)
        }
  while (b < maxhs){
    format (text,73,"^"%-32s^" %-32s %s", nick[b],steamid[b],kills[b])
    write_file (save_data_file, text, b)
    b++
    } 
}
#endif

public plugin_end(){                         /* At mapchange or server shutdown the list will be saved in a file */
  SaveMaster()
  }

public client_death(killer,victim,wpnindex,hitplace,TK) {

   if ((wpnindex == CSW_C4) || TK || is_user_bot(killer) || is_user_bot(victim)) return
   new headshot = ( hitplace == HIT_HEAD ) ? 1:0
   if (!headshot) return
   new killer_name[33], victim_name[33], killer_steamid[33], master_id_str[2], message[128], weapon_name[32]
   get_cvar_string("hs_id",master_id_str,1)
   get_user_name(killer,killer_name,32)
   get_user_authid(killer,killer_steamid,32)
   get_user_name(victim,victim_name,32)
   new j = 0, array_pos = -1, found_flag = 0, master = -1, killnum = 0
   if (get_playersnum() > minplayers){                                /* if more players than minplayers then the kill counts for HS_Master */
     while (j <= maxhs){
       if (equal(master_id_str,"0")){
         if (equal(killer_steamid, steamid[j])){
           array_pos = j
           found_flag = 1
           killnum = str_to_num(kills[j])
           killnum++
           num_to_str(killnum, kills[j], 5)
           nick[j] = killer_name
         }
       }
       else{
           trim(killer_name)
           trim(nick[j])
           if (equal(killer_name, nick[j])){
             array_pos = j
             found_flag = 1
             killnum = str_to_num(kills[j])
             killnum++
             num_to_str(killnum, kills[j], 5)
           }
       }
       j++
     }
     if ((found_flag == 0) && (maxhs < MAX_USERS)){   
       steamid[maxhs] = killer_steamid
       nick[maxhs] = killer_name
       kills[maxhs] = "1"
       if (maxhs == 0){
         master = maxhs
       }
       maxhs++
     }
     else{
       new i = 0
       master = array_pos
       while (i <= maxhs){
         if (str_to_num(kills[array_pos]) <= str_to_num(kills[i])){
           if (i != array_pos){
             master = -1
             break
           }	 
         }
         i++
       }     
     }
     if (master > -1){
       set_cvar_num("HS_Master",master)
       format( message, 127, "%L",LANG_PLAYER,"HS_MSG",nick[master], kills[master],(equal(kills[master],"1"))?"":"S")
       set_hudmessage(0, 255, 0, -1.0, 0.30, 0, 6.0, 6.0, 0.5, 0.15, -1)
       ShowSyncHudMsg(0, syncHud, message )
       client_cmd(0,"spk misc/hsmaster.wav")                             /* If the leader on the list made a headshot the HeadShot Master sound is played */
       return
     }
   }
   xmod_get_wpnname(wpnindex,weapon_name,31)
   format( message, 127, "%L",LANG_PLAYER,messages[ random_num(0,MESSAGES-1) ] )
   replace( message, 127 , "$vn", victim_name )
   replace( message, 127 , "$wn", weapon_name )    
   replace( message, 127 , "$kn", killer_name )
   set_hudmessage(100, 100, 255, -1.0, 0.29, 0, 6.0, 6.0, 0.5, 0.15, -1)
   ShowSyncHudMsg(0, syncHud, message)
    
   client_cmd(killer,"spk misc/headshot") 
   client_cmd(victim,"spk misc/headshot")                                   /* headshot by another player....normal sound */
}

#if defined USING_SQL
public plugin_modules()
{
   require_module("DBI")
}
#endif

public plugin_precache()
{
        
	precache_sound("misc/headshot.wav")                        /* normal headshot sound */
	precache_sound("misc/hsmaster.wav")                      /* HeadShot Master sound */
}